#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion


namespace gov.va.med.vbecs.VAL.UnitTests
{
	[TestFixture]
	public class VAL_Divisions : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			VistALinkUnitTestHarness.RequireConnection();
		}

		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection();
		}

		[Test]
		public void GetDivisionList_Pass()
		{
			DataTable dtTest = DAL.VAL.Divisions.GetDivisionList();

			Assert.IsTrue(dtTest.Rows.Count > 0);
			Assert.IsTrue(dtTest.Columns.Count == 2);
		}
		
		[Test]
		[ExpectedException(typeof(DAL.VistALink.Client.VistALinkClientRPCException))]
		public void GetDivisionList_Fail()
		{
			VistALinkUnitTestHarness.ForcedDisconnect();

			DAL.VAL.Divisions.GetDivisionList();
		}
	}
}
#endif
